#include <iostream>
#include <vector>
#include <queue>
using namespace std;

struct Graph
{
	unsigned long long int v;
	vector<vector<unsigned long long int> > adj;
};

void init_graph(Graph &g,unsigned long long int n)
{
	g.v=n;
	g.adj.resize(n);
}

void addEdge(Graph &g,unsigned long long int u, unsigned long long int v)
{
	g.adj[u].push_back(v);
	g.adj[v].push_back(u);
}

void BFS(Graph &g, vector<unsigned long long int> &v,unsigned long long int x)
{
	queue<unsigned long long int> node;
	queue<unsigned long long int> cost;
	queue<unsigned long long int> parent;
	node.push(x);
	cost.push(0);
	parent.push(-1);
	while(!node.empty())
	{
		unsigned long long int pomnode=node.front();
		unsigned long long int pomcost=cost.front();
		unsigned long long int pomparent=parent.front();
		node.pop();
		cost.pop();
		parent.pop();
		v[pomnode]=pomcost;
	//	cout <<pomnode<<" "<<v[pomnode]<<endl;
		for(unsigned long long int i=0;i<g.adj[pomnode].size();i++)
		{
			if(g.adj[pomnode][i]!=pomparent)
			{
				node.push(g.adj[pomnode][i]);
				cost.push(pomcost+1);
				parent.push(pomnode);
			}
		}
		
	}
}

int main(int argc, char** argv) {
	ios_base::sync_with_stdio(false);
	cin.tie(NULL);
	unsigned long long int n;
	cin >>n;
	vector<unsigned long long int> v(n);
	for(unsigned long long int i=0;i<n;i++)
	{
		cin >>v[i];
	}
	Graph g;
	init_graph(g,n);
	
	for(unsigned long long int i=0;i<n-1;i++)
	{
		unsigned long long int path,cost;
		cin >>path>>cost;
		addEdge(g,path-1,cost-1);
	}
	
	unsigned long long int q;
	cin >>q;
	for(unsigned long long int z=0;z<q;z++)
	{
		/*for(int i=0;i<v.size();i++)
		{
			cout <<v[i]<<" ";
		}
		cout <<endl;*/
		unsigned long long int x;
		cin >>x;
		if(x==1)
		{
			unsigned long long int a,b;
			cin >>a>>b;
			unsigned long long int pom=v[a-1];
			v[a-1]=v[b-1];
			v[b-1]=pom;
		}
		else
		{
			unsigned long long int l,r,y;
			cin >>l>>r>>y;
			vector<unsigned long long int> c(n);
			
			BFS(g,c,y-1);
			
			l--;
			r--;
			unsigned long long int mx=0;
			for(unsigned long long int i=l;i<=r;i++)
			{
				mx=max(mx,c[v[i]-1]);
			}
			cout <<mx<<"\n";
		}
	}
	
	
	return 0;
}